/****** Object:  UserDefinedFunction [dbo].[UFD_EST_PROD_COMIS_REGRESSAO_VALORES]    Script Date: 10/09/2012 14:18:21 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UFD_EST_PROD_COMIS_REGRESSAO_VALORES]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
DROP FUNCTION [dbo].[UFD_EST_PROD_COMIS_REGRESSAO_VALORES]
GO  
--SELECT * FROM UFD_EST_PROD_COMIS_REGRESSAO_VALORES (1,48,36846,0,32)
CREATE FUNCTION [dbo].[UFD_EST_PROD_COMIS_REGRESSAO_VALORES]  (@CD_EMP  INT,      
															@CD_FILIAL INT,  
															@CD_PROD INT,      
															@CD_FUN  INT,  
															@PERC_DESC MONEY,
															@PERC_DESC_CAD MONEY)  
RETURNS @RS_TAB_COMIS TABLE (CD_TBL_COMIS_REGRESSAO  INT,  
							  TP_NIVEL	INT,  
							  PERC_COMIS	MONEY,   
							  CD_PROD		INT,  
							  CD_FILIAL   INT,  
							  CD_EMP		INT)  
WITH ENCRYPTION AS                
BEGIN                
          
DECLARE @RS_TAB_ATIVA AS TABLE (CD_EMP INT, 
								 CD_TBL_COMIS_REGRESSAO INT,
								 FLAG_REGRESSAO_ACRESCIMO_DESCONTO INT
								 UNIQUE CLUSTERED (CD_EMP, CD_TBL_COMIS_REGRESSAO) ) 

DECLARE @RS_DADOS_TBL_COMIS AS TABLE (CD_TBL_COMIS_REGRESSAO INT, 
									  TP_NIVEL		INT, 
									  PERC_COMIS	MONEY,  
									  DESC_INI		MONEY,  
									  DESC_FIM		MONEY)  

DECLARE @CD_GRP_ECON INT
SET @CD_GRP_ECON = (SELECT TOP 1 CD_GRP_ECON
					FROM PRC_GRP_ECON_PRC_FILIAL
					WHERE
						CD_EMP =@CD_EMP
						AND CD_FILIAL =@CD_FILIAL)

 -------------------------------------------------------------------------------------------------------------------------------      
 --DECLARANDO TABELA DE ARVORE MERCADOLOGICA DO PRODUTO      
 -------------------------------------------------------------------------------------------------------------------------------      
 DECLARE @EST_PROD_ARV_MERC TABLE (  CD_EMP     INT,      
          CD_PROD   INT,      
          CD_ARV_MERC_CATEG INT,      
          CD_ARV_MERC_SEG INT,      
          CD_ARV_MERC_PAPEL INT,      
          CD_ARV_MERC_MIX INT,      
          CD_ARV_MERC_CONSUMO INT,      
          CD_ARV_MERC_LINHA INT,      
          CD_ARV_MERC_MTZ_BCG INT,      
          CD_MC   INT,      
          CD_ARV_MERC_FAMILIA INT,              
          CD_APRES   INT,          
          CD_ARV_MERC_EQUI INT,      
          CD_GRP_EXPO  INT,      
          CD_FABRIC   INT)      
            
 -------------------------------------------------------------------------------------------------------------------------------      
 --BUSCANDO ARVORE MERC. DO PRODUTO      
 -------------------------------------------------------------------------------------------------------------------------------       
	INSERT INTO @EST_PROD_ARV_MERC      
	SELECT       
		ARV.CD_EMP     ,      
		ARV.CD_PROD     ,      
		ARV.CD_ARV_MERC_CATEG  ,      
		ARV.CD_ARV_MERC_SEG   ,      
		ARV.CD_ARV_MERC_PAPEL  ,      
		ARV.CD_ARV_MERC_MIX   ,      
		ARV.CD_ARV_MERC_CONSUMO  ,      
		ARV.CD_ARV_MERC_LINHA  ,      
		ARV.CD_ARV_MERC_MTZ_BCG  ,      
		ARV.CD_MC     ,      
		ARV.CD_ARV_MERC_FAMILIA  ,              
		ARV.CD_APRES    ,          
		ARV.CD_ARV_MERC_EQUI  ,      
		ARV.CD_GRP_EXPO    ,      
		P.CD_FABRIC       
	FROM 
		EST_PROD_EST_ARV_MERCADOLOGICA ARV 
		INNER JOIN EST_PROD P ON      
		ARV.CD_EMP  = P.CD_EMP      
		AND ARV.CD_PROD = P.CD_PROD      
	WHERE   
		P.CD_EMP = @CD_EMP       
		AND P.CD_PROD = @CD_PROD;
           
 -------------------------------------------------------------------------------      
 --CONSULTA TABELAS DE COMISSO PELO TIPO(%/R$) DE COMISSO  
 -------------------------------------------------------------------------------      
	INSERT INTO @RS_TAB_ATIVA      
	SELECT  DISTINCT 
		A.CD_EMP,      
		A.CD_TBL_COMIS_REGRESSAO,
		ISNULL(FLAG_REGRESSAO_ACRESCIMO_DESCONTO,0)
	FROM 
		FP_CARGO_EST_PROD_TBL_COMIS_REGRESSAO COMIS   
		INNER JOIN EST_PROD_TBL_COMIS_REGRESSAO A ON  
		COMIS.CD_EMP = A.CD_EMP AND  
		COMIS.CD_TBL_COMIS_REGRESSAO = A.CD_TBL_COMIS_REGRESSAO  
		INNER JOIN FP_FUNC FUN ON  
		COMIS.CD_EMP = FUN.CD_EMP AND  
		COMIS.CD_CARGO = FUN.CD_CARGO  
	WHERE 
		A.CD_EMP = @CD_EMP 
		AND A.STS_TBL = 0 
		AND FUN.CD_FUN = @CD_FUN 
		AND COMIS.CD_GRP_ECON=@CD_GRP_ECON

--Analisando o tipo de desconto por diferenca de acrescimento 
--de desconto pelo vendedor
IF EXISTS(SELECT
			TOP 1 CD_EMP
		FROM
			@RS_TAB_ATIVA
		WHERE
			FLAG_REGRESSAO_ACRESCIMO_DESCONTO=1)                     
 begin
	if (@PERC_DESC_CAD < @PERC_DESC)
	begin
		SET @PERC_DESC=abs(@PERC_DESC_CAD-@PERC_DESC)
	end
	else
	begin
		SET @PERC_DESC=0
	end
 end
 -------------------------------------------------------------------------------------------------------------------------------      
 --Consultando as tbls de COMISSO no NVEL 1 - PRODUTOS      
 -------------------------------------------------------------------------------------------------------------------------------      
	INSERT INTO @RS_DADOS_TBL_COMIS       
	SELECT TOP 1      
		A.CD_TBL_COMIS_REGRESSAO AS CD_TBL_COMIS_REGRESSAO, 
		1 AS TIPO_NIVEL,	     
		D.PERC_COMIS,      
		D.DESC_INI,      
		D.DESC_FIM   
	FROM 
		EST_PROD_TBL_COMIS_REGRESSAO A   
		INNER JOIN EST_PROD_TBL_COMIS_REGRESSAO_DESCONTOS D ON
		A.CD_EMP = D.CD_EMP AND    	 
		A.CD_TBL_COMIS_REGRESSAO = D.CD_TBL_COMIS_REGRESSAO    
		INNER JOIN EST_PROD_TBL_COMIS_REGRESSAO_EST_PROD B ON      
		A.CD_EMP = B.CD_EMP AND      
		A.CD_TBL_COMIS_REGRESSAO = B.CD_TBL_COMIS_REGRESSAO      
		INNER JOIN EST_PROD_TBL_COMIS_REGRESSAO_PRC_FILIAL FIL ON      
		B.CD_EMP = FIL.CD_EMP AND      
		B.CD_TBL_COMIS_REGRESSAO = FIL.CD_TBL_COMIS_REGRESSAO      
		INNER JOIN @RS_TAB_ATIVA RS_TAB_ATIVA ON      
		B.CD_EMP = RS_TAB_ATIVA.CD_EMP AND      
		B.CD_TBL_COMIS_REGRESSAO = RS_TAB_ATIVA.CD_TBL_COMIS_REGRESSAO       
		INNER JOIN @EST_PROD_ARV_MERC ARV ON      
		B.CD_EMP = ARV.CD_EMP AND      
		B.CD_PROD = ARV.CD_PROD             
	WHERE       
		FIL.CD_FILIAL = @CD_FILIAL      
		AND NOT EXISTS (SELECT 
						T.CD_TBL_COMIS_REGRESSAO 
					 FROM 
						@RS_DADOS_TBL_COMIS T 
					 WHERE 
						T.CD_TBL_COMIS_REGRESSAO = A.CD_TBL_COMIS_REGRESSAO)      
		AND @PERC_DESC BETWEEN D.DESC_INI AND D.DESC_FIM   
   ORDER BY 
		D.PERC_COMIS DESC  
		
 -------------------------------------------------------------------------------------------------------------------------------      
 --Consultando as tbls de COMISSO no NVEL 2 - FAMLIAS      
 -------------------------------------------------------------------------------------------------------------------------------      
	INSERT INTO @RS_DADOS_TBL_COMIS       
	SELECT TOP 1      
		A.CD_TBL_COMIS_REGRESSAO AS CD_TBL_COMIS_REGRESSAO, 
		2 AS TIPO_NIVEL,	     
		D.PERC_COMIS,      
		D.DESC_INI,      
		D.DESC_FIM   
	FROM 
		EST_PROD_TBL_COMIS_REGRESSAO A 
		INNER JOIN EST_PROD_TBL_COMIS_REGRESSAO_DESCONTOS D ON
		A.CD_EMP = D.CD_EMP AND    	 
		A.CD_TBL_COMIS_REGRESSAO = D.CD_TBL_COMIS_REGRESSAO  
		INNER JOIN EST_PROD_TBL_COMIS_REGRESSAO_EST_ARV_MERC_FAMILIA B ON      
		A.CD_EMP = B.CD_EMP AND      
		A.CD_TBL_COMIS_REGRESSAO = B.CD_TBL_COMIS_REGRESSAO      
		INNER JOIN EST_PROD_TBL_COMIS_REGRESSAO_PRC_FILIAL FIL ON      
		B.CD_EMP = FIL.CD_EMP AND      
		B.CD_TBL_COMIS_REGRESSAO = FIL.CD_TBL_COMIS_REGRESSAO      
		INNER JOIN @EST_PROD_ARV_MERC ARV ON      
		B.CD_EMP = ARV.CD_EMP AND      
		B.CD_ARV_MERC_FAMILIA = ARV.CD_ARV_MERC_FAMILIA      
		INNER JOIN @RS_TAB_ATIVA RS_TAB_ATIVA ON      
		A.CD_EMP = RS_TAB_ATIVA.CD_EMP AND      
		B.CD_TBL_COMIS_REGRESSAO = RS_TAB_ATIVA.CD_TBL_COMIS_REGRESSAO          
	WHERE       
		FIL.CD_FILIAL = @CD_FILIAL      
		AND NOT EXISTS (SELECT 
						T.CD_TBL_COMIS_REGRESSAO 
					 FROM 
						@RS_DADOS_TBL_COMIS T 
					 WHERE 
						T.CD_TBL_COMIS_REGRESSAO = A.CD_TBL_COMIS_REGRESSAO)      
		AND @PERC_DESC BETWEEN D.DESC_INI AND D.DESC_FIM   
   ORDER BY 
		D.PERC_COMIS DESC  
  
		
 -------------------------------------------------------------------------------------------------------------------------------          
 --Consultando as tbls de COMISSO no NVEL 3 - MARCAS      
 -------------------------------------------------------------------------------------------------------------------------------      
	INSERT INTO @RS_DADOS_TBL_COMIS       
	SELECT TOP 1      
		A.CD_TBL_COMIS_REGRESSAO AS CD_TBL_COMIS_REGRESSAO, 
		3 AS TIPO_NIVEL,	     
		D.PERC_COMIS,      
		D.DESC_INI,      
		D.DESC_FIM   
	FROM 
		EST_PROD_TBL_COMIS_REGRESSAO A     
		INNER JOIN EST_PROD_TBL_COMIS_REGRESSAO_DESCONTOS D ON
		A.CD_EMP = D.CD_EMP AND    	 
		A.CD_TBL_COMIS_REGRESSAO = D.CD_TBL_COMIS_REGRESSAO  
		INNER JOIN EST_PROD_TBL_COMIS_REGRESSAO_EST_MC B ON      
		A.CD_EMP = B.CD_EMP AND      
		A.CD_TBL_COMIS_REGRESSAO = B.CD_TBL_COMIS_REGRESSAO      
		INNER JOIN EST_PROD_TBL_COMIS_REGRESSAO_PRC_FILIAL FIL ON      
		B.CD_EMP = FIL.CD_EMP AND      
		B.CD_TBL_COMIS_REGRESSAO = FIL.CD_TBL_COMIS_REGRESSAO      
		INNER JOIN @EST_PROD_ARV_MERC ARV ON      
		B.CD_EMP = ARV.CD_EMP AND      
		B.CD_MC  = ARV.CD_MC      
		INNER JOIN @RS_TAB_ATIVA RS_TAB_ATIVA ON      
		A.CD_EMP = RS_TAB_ATIVA.CD_EMP AND      
		B.CD_TBL_COMIS_REGRESSAO = RS_TAB_ATIVA.CD_TBL_COMIS_REGRESSAO          
	WHERE       
		FIL.CD_FILIAL = @CD_FILIAL      
		AND NOT EXISTS (SELECT 
						T.CD_TBL_COMIS_REGRESSAO 
					 FROM 
						@RS_DADOS_TBL_COMIS T 
					 WHERE 
						T.CD_TBL_COMIS_REGRESSAO = A.CD_TBL_COMIS_REGRESSAO)      
		AND @PERC_DESC BETWEEN D.DESC_INI AND D.DESC_FIM   
   ORDER BY 
		D.PERC_COMIS DESC 
 -------------------------------------------------------------------------------------------------------------------------------      
 --Consultando as tbls de COMISSO no NVEL 4 - FABRICANTES      
 -------------------------------------------------------------------------------------------------------------------------------      
	INSERT INTO @RS_DADOS_TBL_COMIS       
	SELECT TOP 1      
		A.CD_TBL_COMIS_REGRESSAO AS CD_TBL_COMIS_REGRESSAO, 
		4 AS TIPO_NIVEL,	     
		D.PERC_COMIS,      
		D.DESC_INI,      
		D.DESC_FIM   
	FROM 
		EST_PROD_TBL_COMIS_REGRESSAO A   
		
		INNER JOIN EST_PROD_TBL_COMIS_REGRESSAO_DESCONTOS D ON
		A.CD_EMP = D.CD_EMP AND    	 
		A.CD_TBL_COMIS_REGRESSAO = D.CD_TBL_COMIS_REGRESSAO     
		INNER JOIN EST_PROD_TBL_COMIS_REGRESSAO_EST_PROD_FABRIC B ON      
		A.CD_EMP = B.CD_EMP AND      
		A.CD_TBL_COMIS_REGRESSAO = B.CD_TBL_COMIS_REGRESSAO      
		INNER JOIN EST_PROD_TBL_COMIS_REGRESSAO_PRC_FILIAL FIL ON      
		B.CD_EMP = FIL.CD_EMP AND      
		B.CD_TBL_COMIS_REGRESSAO = FIL.CD_TBL_COMIS_REGRESSAO      
		INNER JOIN @EST_PROD_ARV_MERC ARV ON      
		B.CD_EMP = ARV.CD_EMP AND      
		B.CD_FABRIC = ARV.CD_FABRIC       
		INNER JOIN @RS_TAB_ATIVA RS_TAB_ATIVA ON      
		B.CD_EMP = RS_TAB_ATIVA.CD_EMP AND      
		B.CD_TBL_COMIS_REGRESSAO = RS_TAB_ATIVA.CD_TBL_COMIS_REGRESSAO          
	     
	WHERE       
		FIL.CD_FILIAL = @CD_FILIAL      
		AND NOT EXISTS (SELECT 
						T.CD_TBL_COMIS_REGRESSAO 
					 FROM 
						@RS_DADOS_TBL_COMIS T 
					 WHERE 
						T.CD_TBL_COMIS_REGRESSAO = A.CD_TBL_COMIS_REGRESSAO)      
		AND @PERC_DESC BETWEEN D.DESC_INI AND D.DESC_FIM   
   ORDER BY 
		D.PERC_COMIS DESC  

		 
-------------------------------------------------------------------------------------------------------------------------------      
 --Consultando as tbls de COMISSO no NVEL 5 - CATEGORIAS      
 -------------------------------------------------------------------------------------------------------------------------------      
	INSERT INTO @RS_DADOS_TBL_COMIS       
	SELECT TOP 1      
		A.CD_TBL_COMIS_REGRESSAO AS CD_TBL_COMIS_REGRESSAO, 
		5 AS TIPO_NIVEL,	     
		D.PERC_COMIS,      
		D.DESC_INI,      
		D.DESC_FIM      
	FROM 
		EST_PROD_TBL_COMIS_REGRESSAO A      
		INNER JOIN EST_PROD_TBL_COMIS_REGRESSAO_DESCONTOS D ON
		A.CD_EMP = D.CD_EMP AND    	 
		A.CD_TBL_COMIS_REGRESSAO = D.CD_TBL_COMIS_REGRESSAO     
		INNER JOIN EST_PROD_TBL_COMIS_REGRESSAO_EST_ARV_MERC_CATEGORIA B ON      
		A.CD_EMP = B.CD_EMP AND      
		A.CD_TBL_COMIS_REGRESSAO = B.CD_TBL_COMIS_REGRESSAO      
		INNER JOIN EST_PROD_TBL_COMIS_REGRESSAO_PRC_FILIAL FIL ON      
		B.CD_EMP = FIL.CD_EMP AND      
		B.CD_TBL_COMIS_REGRESSAO = FIL.CD_TBL_COMIS_REGRESSAO      
		INNER JOIN @EST_PROD_ARV_MERC ARV ON      
		B.CD_EMP = ARV.CD_EMP AND      
		B.CD_ARV_MERC_CATEG = ARV.CD_ARV_MERC_CATEG      
		INNER JOIN @RS_TAB_ATIVA RS_TAB_ATIVA ON      
		A.CD_EMP = RS_TAB_ATIVA.CD_EMP AND      
		B.CD_TBL_COMIS_REGRESSAO = RS_TAB_ATIVA.CD_TBL_COMIS_REGRESSAO          
	WHERE       
		FIL.CD_FILIAL = @CD_FILIAL      
		AND NOT EXISTS (SELECT 
						T.CD_TBL_COMIS_REGRESSAO 
					 FROM 
						@RS_DADOS_TBL_COMIS T 
					 WHERE 
						T.CD_TBL_COMIS_REGRESSAO = A.CD_TBL_COMIS_REGRESSAO)      
		AND @PERC_DESC BETWEEN D.DESC_INI AND D.DESC_FIM   
   ORDER BY 
		D.PERC_COMIS DESC  
		
 ----------------------------------------------------------------------------------------------------------------------------      
 --Consultando as tbls de COMISSO no NVEL 6 - LINHAS      
 -----------------------------------------------------------------------------------------------------------------------------      
	INSERT INTO @RS_DADOS_TBL_COMIS       
	SELECT TOP 1      
		A.CD_TBL_COMIS_REGRESSAO AS CD_TBL_COMIS_REGRESSAO, 
		6 AS TIPO_NIVEL,	     
		D.PERC_COMIS,      
		D.DESC_INI,      
		D.DESC_FIM
	FROM 
		EST_PROD_TBL_COMIS_REGRESSAO A   
		INNER JOIN EST_PROD_TBL_COMIS_REGRESSAO_DESCONTOS D ON
		A.CD_EMP = D.CD_EMP AND      
		A.CD_TBL_COMIS_REGRESSAO = D.CD_TBL_COMIS_REGRESSAO      
		INNER JOIN EST_PROD_TBL_COMIS_REGRESSAO_EST_ARV_MERC_LINHA B ON      
		A.CD_EMP = B.CD_EMP AND      
		A.CD_TBL_COMIS_REGRESSAO = B.CD_TBL_COMIS_REGRESSAO      
		INNER JOIN EST_PROD_TBL_COMIS_REGRESSAO_PRC_FILIAL FIL ON      
		B.CD_EMP = FIL.CD_EMP AND      
		B.CD_TBL_COMIS_REGRESSAO = FIL.CD_TBL_COMIS_REGRESSAO      
		INNER JOIN @EST_PROD_ARV_MERC ARV ON      
		B.CD_EMP = ARV.CD_EMP AND         
		B.CD_ARV_MERC_LINHA = ARV.CD_ARV_MERC_LINHA      
		INNER JOIN @RS_TAB_ATIVA RS_TAB_ATIVA ON      
		A.CD_EMP = RS_TAB_ATIVA.CD_EMP AND      
		B.CD_TBL_COMIS_REGRESSAO = RS_TAB_ATIVA.CD_TBL_COMIS_REGRESSAO          
	WHERE       
		FIL.CD_FILIAL = @CD_FILIAL AND       
		NOT EXISTS (SELECT 
					T.CD_TBL_COMIS_REGRESSAO 
					FROM 
					@RS_DADOS_TBL_COMIS T 
					WHERE 
					T.CD_TBL_COMIS_REGRESSAO = A.CD_TBL_COMIS_REGRESSAO)      
		AND @PERC_DESC BETWEEN D.DESC_INI AND D.DESC_FIM
	ORDER BY 
		D.PERC_COMIS DESC;
 
 -------------------------------------------------------------------------------------------------------------------------------      
 --Consultando as tbls de COMISSO no NVEL 7 - FILIAL      
 -------------------------------------------------------------------------------------------------------------------------------      
	INSERT INTO @RS_DADOS_TBL_COMIS       
	SELECT TOP 1      
		A.CD_TBL_COMIS_REGRESSAO AS CD_TBL_COMIS_REGRESSAO, 
		7 AS TIPO_NIVEL,	     
		D.PERC_COMIS,      
		D.DESC_INI,      
		D.DESC_FIM    
	FROM 
		EST_PROD_TBL_COMIS_REGRESSAO A     
		INNER JOIN EST_PROD_TBL_COMIS_REGRESSAO_DESCONTOS D ON
		A.CD_EMP = D.CD_EMP AND      
		A.CD_TBL_COMIS_REGRESSAO = D.CD_TBL_COMIS_REGRESSAO      
		INNER JOIN EST_PROD_TBL_COMIS_REGRESSAO_PRC_FILIAL B ON      
		A.CD_EMP = B.CD_EMP AND      
		A.CD_TBL_COMIS_REGRESSAO = B.CD_TBL_COMIS_REGRESSAO      
		INNER JOIN @RS_TAB_ATIVA RS_TAB_ATIVA ON      
		A.CD_EMP = RS_TAB_ATIVA.CD_EMP AND      
		B.CD_TBL_COMIS_REGRESSAO = RS_TAB_ATIVA.CD_TBL_COMIS_REGRESSAO          
	WHERE       
			b.CD_FILIAL = @CD_FILIAL AND       
			NOT EXISTS (SELECT 
						T.CD_TBL_COMIS_REGRESSAO 
						FROM 
						@RS_DADOS_TBL_COMIS T 
						WHERE 
						T.CD_TBL_COMIS_REGRESSAO = A.CD_TBL_COMIS_REGRESSAO)      
			AND @PERC_DESC BETWEEN D.DESC_INI AND D.DESC_FIM
		ORDER BY 
			D.PERC_COMIS DESC;


	INSERT INTO @RS_TAB_COMIS   
	SELECT TOP 1 
		CD_TBL_COMIS_REGRESSAO,  
		TP_NIVEL,
		PERC_COMIS,   
		@CD_PROD AS CD_PROD,  
		@CD_FILIAL AS CD_FILIAL,  
		@CD_EMP AS CD_EMP  
	FROM 
		@RS_DADOS_TBL_COMIS A  
	WHERE
		@PERC_DESC BETWEEN DESC_INI AND DESC_FIM
	ORDER BY 
		TP_NIVEL ASC, 
		PERC_COMIS DESC  
  
RETURN  
  
END        
  